/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.ModMetadataParser;
import net.fabricmc.loader.impl.metadata.ParseMetadataException;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.connector.ConnectorEarlyLoader;
import org.sinytra.connector.locator.ConnectorFabricModMetadata;
import org.sinytra.connector.locator.DependencyResolver;
import org.sinytra.connector.transformer.jar.EarlyJSCoremodTransformer;
import org.sinytra.connector.transformer.jar.JarTransformInstance;
import org.sinytra.connector.util.ConnectorUtil;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.spongepowered.asm.launch.MixinLaunchPluginLegacy;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.service.MixinService;
import reloc.net.minecraftforge.fart.api.ClassProvider;

public final class JarTransformer {
    public static final String SOURCE_NAMESPACE = "intermediary";
    public static final String OBF_NAMESPACE = "mojang";
    public static final Marker TRANSFORM_MARKER = MarkerFactory.getMarker((String)"TRANSFORM");
    private static final String MAPPED_SUFFIX = "_mapped_moj_" + FMLLoader.versionInfo().mcVersion();
    private static final Path GENERATED_JAR_PATH = ConnectorUtil.CONNECTOR_FOLDER.resolve("adapter/adapter_generated_mixins.jar");
    private static final String LOOM_GENERATED_PROPERTY = "fabric-loom:generated";
    private static final String LOOM_REMAP_ATTRIBUTE = "Fabric-Loom-Remap";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final VarHandle TRANSFORMER_LOADER_FIELD = (VarHandle)LambdaExceptionUtils.uncheck(() -> MethodHandles.privateLookupIn(MixinLaunchPluginLegacy.class, MethodHandles.lookup()).findVarHandle(MixinLaunchPluginLegacy.class, "transformerLoader", ILaunchPluginService.ITransformerLoader.class));

    private static void setMixinClassProvider(ILaunchPluginService.ITransformerLoader loader) {
        try {
            MixinLaunchPluginLegacy plugin = (MixinLaunchPluginLegacy)MixinService.getService().getBytecodeProvider();
            TRANSFORMER_LOADER_FIELD.set(plugin, loader);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Path getGeneratedJarPath() {
        return GENERATED_JAR_PATH;
    }

    public static List<TransformedFabricModPath> transform(List<TransformableJar> jars, List<Path> libs, Collection<IModFile> loadedMods) {
        ArrayList<TransformedFabricModPath> transformed = new ArrayList<TransformedFabricModPath>();
        ArrayList<Path> inputLibs = new ArrayList<Path>(libs);
        ArrayList<TransformableJar> needTransforming = new ArrayList<TransformableJar>();
        for (TransformableJar jar : jars) {
            if (jar.cacheFile().isUpToDate()) {
                transformed.add(jar.toTransformedPath());
            } else {
                needTransforming.add(jar);
            }
            inputLibs.add(jar.input().toPath());
        }
        if (!needTransforming.isEmpty()) {
            transformed.addAll(JarTransformer.transformJars(needTransforming, inputLibs, loadedMods));
        }
        return transformed;
    }

    public static TransformableJar cacheTransformableJar(File input) throws IOException {
        Files.createDirectories(ConnectorUtil.CONNECTOR_FOLDER, new FileAttribute[0]);
        String name = input.getName().split("\\.(?!.*\\.)")[0];
        Path output = ConnectorUtil.CONNECTOR_FOLDER.resolve(name + MAPPED_SUFFIX + ".jar");
        FabricModFileMetadata metadata = JarTransformer.readModMetadata(input);
        FabricModPath path = new FabricModPath(output, metadata);
        ConnectorUtil.CacheFile cacheFile = ConnectorUtil.getCached(input.toPath(), output);
        String moduleName = JarTransformer.getModuleName(input.toPath());
        return new TransformableJar(input, path, cacheFile, moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TransformedFabricModPath> transformJars(List<TransformableJar> paths, List<Path> libs, Collection<IModFile> loadedMods) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ProgressMeter progress = StartupNotificationManager.prependProgressBar((String)"[Connector] Transforming Jars", (int)paths.size());
        try {
            JarTransformInstance transformInstance;
            ProgressMeter initProgress = StartupNotificationManager.prependProgressBar((String)"[Connector] Initializing Transformer", (int)0);
            try {
                ClassProvider classProvider = ClassProvider.fromPaths((Path[])libs.toArray(Path[]::new));
                EarlyJSCoremodTransformer transformingClassProvider = EarlyJSCoremodTransformer.create(classProvider, loadedMods);
                ILaunchPluginService.ITransformerLoader loader = name -> transformingClassProvider.getClassBytes(name.replace('.', '/')).orElseThrow(() -> new ClassNotFoundException(name));
                JarTransformer.setMixinClassProvider(loader);
                transformInstance = new JarTransformInstance(transformingClassProvider, loadedMods, libs);
            }
            finally {
                initProgress.complete();
            }
            ExecutorService executorService = Executors.newFixedThreadPool(paths.size());
            List<Pair> futures = paths.stream().map(jar -> {
                Future<Pair> future = executorService.submit(() -> {
                    Pair<FabricModPath, PatchAuditTrail> pair = jar.transform(transformInstance);
                    progress.increment();
                    return pair;
                });
                return Pair.of((Object)jar.input(), future);
            }).toList();
            executorService.shutdown();
            if (!executorService.awaitTermination(1L, TimeUnit.HOURS)) {
                throw new RuntimeException("Timed out waiting for jar remap");
            }
            List<TransformedFabricModPath> results = futures.stream().map(pair -> {
                try {
                    Pair result = (Pair)((Future)pair.getSecond()).get();
                    return new TransformedFabricModPath(((File)pair.getFirst()).toPath(), (FabricModPath)result.getFirst(), (PatchAuditTrail)result.getSecond());
                }
                catch (Throwable t) {
                    throw new ModLoadingException(ConnectorEarlyLoader.createGenericLoadingIssue(t, "Error transforming file " + ((File)pair.getFirst()).getName()));
                }
            }).filter(Objects::nonNull).toList();
            LambdaExceptionUtils.uncheck(() -> transformInstance.getBfu().saveGeneratedAdapterJar());
            transformInstance.saveAuditReport();
            stopwatch.stop();
            LOGGER.debug(TRANSFORM_MARKER, "Processed all jars in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            List<TransformedFabricModPath> list = results;
            return list;
        }
        catch (InterruptedException ignored) {
            List<TransformedFabricModPath> list = List.of();
            return list;
        }
        finally {
            JarTransformer.cleanupEnvironment();
            progress.complete();
        }
    }

    private static FabricModFileMetadata readModMetadata(File input) throws IOException {
        try (JarFile jarFile = new JarFile(input);){
            HashSet<String> configs;
            ConnectorFabricModMetadata metadata;
            try (InputStream ins = jarFile.getInputStream(jarFile.getEntry("fabric.mod.json"));){
                LoaderModMetadata rawMetadata = ModMetadataParser.parseMetadata(ins, "", Collections.emptyList(), DependencyResolver.VERSION_OVERRIDES, DependencyResolver.DEPENDENCY_OVERRIDES.get(), false);
                DependencyResolver.removeAliasedModDependencyConstraints(rawMetadata);
                metadata = new ConnectorFabricModMetadata(rawMetadata);
                configs = new HashSet<String>(metadata.getMixinConfigs(FabricLoader.getInstance().getEnvironmentType()));
            }
            catch (ParseMetadataException e) {
                throw new RuntimeException(e);
            }
            boolean containsAT = jarFile.getEntry("META-INF/accesstransformer.cfg") != null;
            HashSet<String> refmaps = new HashSet<String>();
            HashSet<String> mixinPackages = new HashSet<String>();
            for (String configName : configs) {
                ZipEntry entry2 = jarFile.getEntry(configName);
                if (entry2 == null) continue;
                JarTransformer.readMixinConfigPackages(input, jarFile, entry2, refmaps, mixinPackages);
            }
            jarFile.stream().forEach(entry -> {
                String name = entry.getName();
                if ((name.endsWith(".mixins.json") || name.startsWith("mixins.") && name.endsWith(".json")) && configs.add(name)) {
                    JarTransformer.readMixinConfigPackages(input, jarFile, entry, refmaps, mixinPackages);
                }
            });
            Attributes manifestAttributes = Optional.ofNullable(jarFile.getManifest()).map(Manifest::getMainAttributes).orElseGet(Attributes::new);
            boolean generated = JarTransformer.isGeneratedLibraryJarMetadata(manifestAttributes, metadata);
            FabricModFileMetadata fabricModFileMetadata = new FabricModFileMetadata(metadata, Set.copyOf(configs), configs, refmaps, mixinPackages, manifestAttributes, containsAT, generated);
            return fabricModFileMetadata;
        }
    }

    private static boolean isGeneratedLibraryJarMetadata(Attributes manifestAttributes, LoaderModMetadata metadata) {
        CustomValue generatedValue = metadata.getCustomValue(LOOM_GENERATED_PROPERTY);
        if (generatedValue != null && generatedValue.getType() == CustomValue.CvType.BOOLEAN && generatedValue.getAsBoolean()) {
            String loomRemapAttribute = manifestAttributes.getValue(LOOM_REMAP_ATTRIBUTE);
            return loomRemapAttribute == null || !loomRemapAttribute.equals("true");
        }
        return false;
    }

    private static void readMixinConfigPackages(File input, JarFile jarFile, ZipEntry entry, Set<String> refmaps, Set<String> packages) {
        try (InputStreamReader reader = new InputStreamReader(jarFile.getInputStream(entry));){
            String pkg;
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (json.has("refmap")) {
                String refmap = json.get("refmap").getAsString();
                refmaps.add(refmap);
            }
            if (json.has("package") && !(pkg = json.get("package").getAsString()).isEmpty()) {
                String pkgPath = pkg.replace('.', '/') + "/";
                packages.add(pkgPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading mixin config entry {} in file {}", (Object)entry.getName(), (Object)input.getAbsolutePath());
            throw new UncheckedIOException(e);
        }
    }

    private static void cleanupEnvironment() {
        JarTransformer.setMixinClassProvider(null);
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(ClassInfo.class, MethodHandles.lookup());
            VarHandle cacheField = lookup.findStaticVarHandle(ClassInfo.class, "cache", Map.class);
            Map cache = cacheField.get();
            cache.clear();
            VarHandle objectField = lookup.findStaticVarHandle(ClassInfo.class, "OBJECT", ClassInfo.class);
            ClassInfo object = objectField.get();
            cache.put("java/lang/Object", object);
        }
        catch (Throwable t) {
            LOGGER.error("Error cleaning up after jar transformation", t);
        }
    }

    @Nullable
    private static String getModuleName(Path path) {
        String string;
        block8: {
            JarContents contents = new JarContentsBuilder().paths(new Path[]{path}).build();
            try {
                JarMetadata metadata = JarMetadata.from((JarContents)contents);
                string = metadata.descriptor().name();
                if (contents == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading jar contents from {}", (Object)path, (Object)e);
                    return null;
                }
            }
            contents.close();
        }
        return string;
    }

    private JarTransformer() {
    }

    public record TransformableJar(File input, FabricModPath modPath, ConnectorUtil.CacheFile cacheFile, String moduleName) {
        public Pair<FabricModPath, PatchAuditTrail> transform(JarTransformInstance transformInstance) throws IOException {
            Files.deleteIfExists(this.modPath.path);
            PatchAuditTrail audit = transformInstance.transformJar(this.input, this.modPath.path, this.modPath.metadata());
            this.cacheFile.save();
            return Pair.of((Object)this.modPath, (Object)audit);
        }

        public TransformedFabricModPath toTransformedPath() {
            return new TransformedFabricModPath(this.input.toPath(), this.modPath, null);
        }
    }

    public record TransformedFabricModPath(Path input, FabricModPath output, @Nullable PatchAuditTrail auditTrail) {
    }

    public record FabricModFileMetadata(ConnectorFabricModMetadata modMetadata, Collection<String> visibleMixinConfigs, Collection<String> mixinConfigs, Set<String> refmaps, Set<String> mixinPackages, Attributes manifestAttributes, boolean containsAT, boolean generated) {
    }

    public record FabricModPath(Path path, FabricModFileMetadata metadata) {
    }
}

